<?php
/**
 * The header for Astra Theme.
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package Astra
 * @since 1.0.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

?><!DOCTYPE html>
<?php astra_html_before(); ?>
<html <?php language_attributes(); ?>>
<head>
	<link rel="stylesheet" type="text/css" href="https://www.sumita.com/Test/style.css'" id="style_color"/>
<?php astra_head_top(); ?>
<meta charset="<?php bloginfo( 'charset' ); ?>">
<meta name="viewport" content="width=device-width, initial-scale=1">
<?php 
if ( apply_filters( 'astra_header_profile_gmpg_link', true ) ) {
	?>
	 <link rel="profile" href="https://gmpg.org/xfn/11"> 
	 <?php
} 
?>
<?php wp_head(); ?>
<?php astra_head_bottom(); ?>
		<script>  

		jQuery(document).ready(function(){
			
			jQuery(".add_to_cart_button,.button.wp-element-button.product_type_variable,.button.wp-element-button.product_type_simple").hide();
	        jQuery(".button.product_type_variable,.button.product_type_simple").hide();
	
	}); 
		
	</script>
</head>

<body <?php astra_schema_body(); ?> <?php body_class(); ?>>
<?php astra_body_top(); ?>
<?php wp_body_open(); ?>

<a
	class="skip-link screen-reader-text"
	href="#content"
	role="link"
	title="<?php echo esc_attr( astra_default_strings( 'string-header-skip-link', false ) ); ?>">
		<?php echo esc_html( astra_default_strings( 'string-header-skip-link', false ) ); ?>
</a>

<div
<?php
	echo astra_attr(
		'site',
		array(
			'id'    => 'page',
			'class' => 'hfeed site',
		)
	);
	?>
>
	<?php
	astra_header_before();

	astra_header();

	astra_header_after();

	astra_content_before();
	?>
	<div id="content" class="site-content">
		<div class="ast-container">
		<?php astra_content_top(); ?>
			
			<script> 	  
	
	jQuery(document).ready(function(){
	jQuery(".summary entry-summary .stock.out-of-stock").hide();
	
	
	var heading = jQuery("#accessories h2");
            
            // Create the hyperlink element
            var link = jQuery("<a>", {
                href: "https://www.sumita.com/?product_cat=accessories",
                class: "link", // Apply the link styles
                html: heading.html() // Use the existing content of the heading
            });
            
            // Replace the heading with the hyperlink
            heading.replaceWith(link);
	var heading = jQuery("#accessories h2");
	});

	
		jQuery(document).ready(function(){
			var heading = jQuery("#eye_care h2");
            
            // Create the hyperlink element
            var link_eye = jQuery("<a>", {
                href: "https://www.sumita.com/?product_cat=eye-care",
                class: "link_eye", // Apply the link styles
                html: heading.html() // Use the existing content of the heading
            });
            
            // Replace the heading with the hyperlink
            heading.replaceWith(link_eye);
	var heading = jQuery("#eye_care h2");
	});
	
 
jQuery(window).scroll(function() {
  if (jQuery(document).scrollTop() > 20) {
      jQuery('#nav_menu').addClass('fixed-top');

  } else {
      jQuery('#nav_menu').removeClass('fixed-top');
  }
}); 
  jQuery(document).ready(function () {
    // Get the video container
    var videoContainer =jQuery("#rslides1_s0");

    // Create a video element
    var videoElement = jQuery("<video autoplay loop muted>")
      .append("<source src='https://www.sumita.com/wp-content/uploads/2023/05/Sumita-Cosmetics-_Beauty-in-Focus._-A-niche-brand-specifically-developed-for-eyes-brows.mp4' type='video/mp4'>")
      .append("Your browser does not support the video tag.");

    // Replace the image with the video
    videoContainer.html(videoElement);
  });
	
</script>
